#include <afxwin.h>
#include <winsock.h>
#include "Resource.h"
#include "KeepAlive.h"

#define local static

// netcom.cpp - network support code

#define local static

/* FilterBuf readies a buffer of chars for edit control display. It replaces
   CR's & LF's with CR/LF pairs, while eating blank lines and filtering
   control characters.
 */
void FilterBuf(char *buf,int bufSiz)
{
	BOOL cr;
	CString s="";
	char *p=buf;

	buf[bufSiz-1]=0;			// guarantee input buffer is null-terminated

	for (cr=TRUE;*p;p++) {		// starting TRUE eats leading blank lines, if any
		if ((*p == 10) || (*p == 13)) {
			if (cr)				// eat multiple blank lines
				continue;
			s += 13;
			s += 10;
			cr=TRUE;
			continue;
		}

		cr=FALSE;

		if (*p < ' ')			// eat control chars
			continue;

		s += *p;
	}

	strncpy(buf,s,bufSiz-1);	// last char is STILL null
}

short DefaultFingerPort()					// "kosher" way to find port
{
	struct servent *lpServEnt;
	short fp;

	if (!(lpServEnt=getservbyname("finger",NULL)))
		return(IPPORT_FINGER);

	fp=ntohs(lpServEnt->s_port);

	return(fp);
}

/*-----------------------------------------------------------
 * Function: GetHostID()
 *
 * Description: 
 *  Get the Local IP address using the following algorithm:
 *    - get local hostname with gethostname()
 *    - attempt to resolve local hostname with gethostbyname()
 *    if that fails:
 *    - get a UDP socket
 *    - connect UDP socket to arbitrary address and port
 *    - use getsockname() to get local address
 *
 * (Thanks to "Windows Network Programming" by
 *    Bob Quinn & Dave Shulte for the routine - djh)
 */

#define MAXHOSTNAME   128   /* Maximum length of a DNS hostname */

LONG GetHostID () {
    char szLclHost [MAXHOSTNAME];
    LPHOSTENT lpstHostent;
    SOCKADDR_IN stLclAddr;
    SOCKADDR_IN stRmtAddr;
    int nAddrSize = sizeof(SOCKADDR);
    SOCKET hSock;
    int nRet;
    
    /* Init local address (to zero) */
    stLclAddr.sin_addr.s_addr = INADDR_ANY;
    
    /* Get the local hostname */
    nRet = gethostname(szLclHost, MAXHOSTNAME);
	
    if (nRet != SOCKET_ERROR) {
      /* Resolve hostname for local address */
      lpstHostent = gethostbyname((LPSTR)szLclHost);

      if (lpstHostent)
        stLclAddr.sin_addr.s_addr = *((u_long FAR*) (lpstHostent->h_addr));
    } 
    
    /* If still not resolved, then try second strategy */
    if (stLclAddr.sin_addr.s_addr == INADDR_ANY) {

      /* Get a UDP socket */
      hSock = socket(AF_INET, SOCK_DGRAM, 0);

      if (hSock != INVALID_SOCKET)  {
        /* Connect to arbitrary port and address (NOT loopback) */

        stRmtAddr.sin_family = AF_INET;
        stRmtAddr.sin_port   = htons(IPPORT_ECHO);
        stRmtAddr.sin_addr.s_addr = inet_addr("128.127.50.1");

        nRet = connect(hSock,
                       (LPSOCKADDR)&stRmtAddr,
                       sizeof(SOCKADDR));

        if (nRet != SOCKET_ERROR) {
          /* Get local address */
          getsockname(hSock, 
                      (LPSOCKADDR)&stLclAddr, 
                      (int FAR*)&nAddrSize);
        }

        closesocket(hSock);   /* we're done with the socket */
      }
    }
    return (stLclAddr.sin_addr.s_addr);
}
