#include <afxwin.h>
#include <winsock.h>
#include "Resource.h"
#include "KeepAlive.h"

// fingerprot.cpp - Finger protocol code

BOOL CAliveDialog::ConnectHostAsync(const char *host)
{	
	BOOL err=TRUE;
	HWND hwnd=m_hWnd;	//Note: AfxGetMainWnd() doesn't work

	// Create a generic TCP socket
	if ((ts.s=socket(PF_INET,SOCK_STREAM,0))==INVALID_SOCKET)
		return(TRUE);

	// Make it asynchronous

	if (WSAAsyncSelect(ts.s,hwnd,WINSOCK_EVENT,
			FD_READ|FD_WRITE|FD_CONNECT|FD_CLOSE)==SOCKET_ERROR)
		goto cleanup;

	if (!WSAAsyncGetHostByName(hwnd,LOOKUP_EVENT,host,ts.acHostInfo,sizeof(ts.acHostInfo)))
		goto cleanup;
	
	err=FALSE;

cleanup:
	if (err)
		closesocket(ts.s);

	return(err);
}

BOOL CAliveDialog::OnFinger()
{
	char *hostName;
	BOOL err=TRUE;

	// Return immediately if a finger's already in progress!
	if (ts.inProgress)
		return(FALSE);

	ts.inProgress=TRUE;

	strcpy(ts.userName,m_URL);					// copy "user@test.com", we'll be modifying it
      
    if (!(hostName=strchr(ts.userName,'@')))	// Search for host separator
		return(TRUE);			   				// If not there, quit
       
    *hostName++ = '\0';						   	// zap separator & point to host name
	sprintf(ts.fingerOutBuf,"%s\r\n",ts.userName);// Cook finger output command

	PrintFinger(TRUE,FALSE,TRUE);				// Displays "Connecting host..."
	return(ConnectHostAsync(hostName),FALSE);	// Remaining setup done after FD_CONNECT
}

// New for Async Winsock: DNS Lookup Completed
LRESULT CAliveDialog::OnLookupEvent(WPARAM wParam,LPARAM lParam)
{
	int nWSAErr;
	BOOL err=TRUE;

	if (nWSAErr=WSAGETSELECTERROR(lParam))	// DNS lookup failed?
		goto cleanup;

    ts.sin.sin_family = AF_INET;
    ts.sin.sin_port = htons(m_port);	// Convert channel (such as
										// IPPORT_FINGER (79)) to big-endian
										// network byte-order

	// DNS lookup OK; get IP addr of server from filled-in hostent buffer

	ts.hostIP.s_addr =	
		ts.sin.sin_addr.s_addr = 
			*((u_long FAR *)((struct hostent FAR *)ts.acHostInfo)->h_addr);

	// and try to connect to it
    if (connect(ts.s,(LPSOCKADDR)&ts.sin,sizeof(SOCKADDR_IN))==SOCKET_ERROR) {
		if ((nWSAErr=WSAGetLastError()) != WSAEWOULDBLOCK)
			goto cleanup;
	}
 
	err=FALSE;

cleanup:
	if (err)
		closesocket(ts.s);

	PrintFinger(FALSE,err,FALSE);	// display hostIP address

	return(0);
};

// New for Async Winsock: Dispatch routine
LRESULT CAliveDialog::OnWinsockEvent(WPARAM wParam,LPARAM lParam)
{
	int nWSAEvent=WSAGETSELECTEVENT(lParam);
	int nWSAErr=WSAGETSELECTERROR(lParam);
	int nRet;

	// A common error we might see is WSAECONNREFUSED, when
	// connecting to a legitimate site that doesn't support
	// finger requests. The event here would be FD_CONNECT.
	
	if (nWSAErr) {
#if 0
		char buf[100];
		sprintf(buf,"nWSAEvent=%d,nWSAErr=%d",nWSAEvent,nWSAErr);
		MessageBox(buf,"Winsock Error", MB_ICONEXCLAMATION);
#endif
		goto cleanup;
	}

	switch (nWSAEvent) {
		case FD_CONNECT:
			// All of this could be done higher up
			ts.nBytesToXfer=strlen(ts.fingerOutBuf);
			ts.nBytesXferred=0;
			ts.nBytesReceived=0;
			return(TRUE);

		case FD_WRITE:
			if (ts.nBytesXferred == ts.nBytesToXfer)
				return(TRUE);

			nRet=send(ts.s,(LPSTR)&(ts.fingerOutBuf[ts.nBytesXferred]),ts.nBytesToXfer-ts.nBytesXferred,0);

			if (nRet==SOCKET_ERROR) {
				nWSAErr=WSAGetLastError();

				if (nWSAErr!=WSAEWOULDBLOCK)	// outgoing buffer unavailable
					goto cleanup;
			}

			ts.nBytesXferred+=nRet;

			if (ts.nBytesXferred==ts.nBytesToXfer)
				shutdown(ts.s,1);	// send <FIN> to server
			return(TRUE);

		case FD_READ:
			nRet=recv(ts.s,(LPSTR)ts.fingerInBuf+ts.nBytesReceived,sizeof(ts.fingerInBuf)-ts.nBytesReceived,0);

			if (nRet==SOCKET_ERROR) {
				nWSAErr=WSAGetLastError();

				if (nWSAErr!=WSAEWOULDBLOCK)
					goto cleanup;
			}
			else
				ts.nBytesReceived+=nRet;

			if (!nRet) {
				FilterBuf(ts.fingerInBuf,sizeof(ts.fingerInBuf));
				PrintFinger(FALSE,FALSE,TRUE);	// Here's where it gets displayed!
			}

			return(TRUE);

		case FD_CLOSE:	// Server finished sending to us. This never seems
						// to get called with Finger - maybe finger servers
						// keep connection open for more requests?
			nRet=1;

			// FD_CLOSE's tend to get ahead of other msgs in
			// the queue. Retrieve any unfetched input leftover.

			while (nRet && (nRet!=SOCKET_ERROR)) {
				nRet=recv(ts.s,ts.fingerInBuf+ts.nBytesReceived,sizeof(ts.fingerInBuf)-ts.nBytesReceived,0);
				ts.nBytesReceived+=nRet;
			}

			closesocket(ts.s);

			ts.fingerInBuf[ts.nBytesReceived]='\0';	// terminate finger result
			FilterBuf(ts.fingerInBuf,sizeof(ts.fingerInBuf));
			PrintFinger(FALSE,FALSE,TRUE);	// Here's where it gets displayed!
			return(TRUE);
	}

cleanup:
	closesocket(ts.s);	// is this wise?
	PrintFinger(FALSE,TRUE,FALSE);
	return(TRUE);
}
