#include <afxwin.h>
#include <winsock.h>
#include "Resource.h"
#include "KeepAlive.h"

// aliveclass.cpp - CAliveClass (main window) code

// for Windows messages

BEGIN_MESSAGE_MAP (CAliveDialog, CDialog)
    ON_WM_PAINT ()
    ON_WM_SYSCOMMAND ()
	ON_WM_TIMER ()
	ON_MESSAGE(LOOKUP_EVENT, OnLookupEvent)		// async Winsock
	ON_MESSAGE(WINSOCK_EVENT, OnWinsockEvent)	// async Winsock
	ON_BN_CLICKED (IDC_DEFAULT, OnDefault)
	ON_BN_CLICKED (IDC_UNDO, OnUndo)
	ON_BN_CLICKED (IDC_APPLY, OnApply)
	ON_BN_CLICKED (IDC_FINGER, OnFinger)
	ON_EN_CHANGE (IDC_URL, OnEditChange)
	ON_EN_CHANGE (IDC_TIMEOUT, OnEditChange)
	ON_EN_CHANGE (IDC_PORT, OnEditChange)
END_MESSAGE_MAP ()

/////////////////////////////////////////////////////////////////////////
// CAliveDialog "hidden" member functions

CAliveDialog::CAliveDialog ()	// constructor
{
	CWinApp* pApp = AfxGetApp();

    Create (IDD_ALIVEDLG);
    SetIcon (pApp->LoadIcon (IDI_ALIVEDLG), TRUE);

	// Clear out temporary winsock state info

	ZeroMemory(&ts,sizeof(ts));
}

BOOL CAliveDialog::OnInitDialog ()
{
    CDialog::OnInitDialog ();

	// Remove default system menus from dialog box and
	// replace with ours for the about box. Cool.

    CMenu* pMenu = GetSystemMenu (FALSE);
    pMenu->DeleteMenu (SC_SIZE, MF_BYCOMMAND);
    pMenu->DeleteMenu (SC_MAXIMIZE, MF_BYCOMMAND);
    pMenu->AppendMenu (MF_SEPARATOR);
    pMenu->AppendMenu (MF_STRING, IDM_SYSMENU_ABOUT,
        "&About KeepAlive...");

	firstTime=TRUE;		// Perform quick finger on startup
	RestoreSettings();

    return TRUE;
}

void CAliveDialog::OnOK ()
{
	OnApply();			// Auto-apply, not close, when modeless edit ctrls are ENTERed
}

void CAliveDialog::OnCancel ()
{
    DestroyWindow ();	// Have to handle this ourselves - we're non-modal!
}

void CAliveDialog::PostNcDestroy ()
{
    delete this;		// Have to handle this ourselves - we're non-modal!
}

void CAliveDialog::MySetTimer()
{
	if (m_timeout) {
		// Possibly force a quick finger upon startup

		if (!SetTimer(ID_TIMER_CLOCK,(firstTime?STARTUP_FINGER_SECS:m_timeout)*1000,NULL)) {
			MessageBox("SetTimer failed","Error",MB_ICONSTOP|MB_OK);
			return;
		}
	} else KillTimer(ID_TIMER_CLOCK);	// OK if timer wasn't available to kill
}

/////////////////////////////////////////////////////////////////////////
// CAliveDialog "active" member functions

void CAliveDialog::OnPaint ()
{
    CPaintDC dc (this);
}

void CAliveDialog::OnSysCommand (UINT nID, LPARAM lParam)
{
    if ((nID & 0xFFF0) == IDM_SYSMENU_ABOUT) {
        CAboutDialog dlg (this);
        dlg.DoModal ();
        return;
    }
    CDialog::OnSysCommand (nID, lParam);
}

void CAliveDialog::OnTimer (UINT nTimerID)
{
	OnFinger();

	if (firstTime) {		// Reset startup timer back to normal 
		firstTime=FALSE;
		MySetTimer();
	}
}

void CAliveDialog::SyncUndo ()
{
	SetDlgItemText(IDC_RESPONSE,"No response.");

	OnApply();

	// Initialize the UNDO buffer to the current state as well

	u_URL = m_URL;
	u_timeout = m_timeout;
	u_port = m_port;

	// Clear the host's IP address until next finger
	SetDlgItemText(IDC_HOSTIP,"");

	// nothing to undo, really - they're the same!
	((CButton *)GetDlgItem(IDC_UNDO))->EnableWindow(FALSE);
}

void CAliveDialog::RestoreSettings ()
{
	CWinApp* pApp = AfxGetApp();
	CString s;
	struct in_addr clientIP;
	int i;

	// Zap the dialog strings from Registry (if avail) and apply to result

	SetDlgItemText(IDC_URL,pApp->GetProfileString(KEY_VERSION,KEY_DEFAULT_URL,DEFAULT_URL));

	i=pApp->GetProfileInt(KEY_VERSION,KEY_DEFAULT_TIMEOUT,DEFAULT_TIMEOUT_SECS);
    s.Format("%d",i);
	SetDlgItemText(IDC_TIMEOUT,s);

	i=pApp->GetProfileInt(KEY_VERSION,KEY_DEFAULT_PORT,DefaultFingerPort());
	s.Format("%d",i);
	SetDlgItemText(IDC_PORT,s);

	// Find out what our IP address is and display it
	clientIP.s_addr=GetHostID();
	SetDlgItemText(IDC_CLIENTIP,inet_ntoa(clientIP));


	SyncUndo();
}

void CAliveDialog::OnDefault ()	// more like "Reset Factory Defaults"
{
	CWinApp* pApp = AfxGetApp();
	CString s;

	// Zap the dialog strings from Registry (if avail) and apply to result

	SetDlgItemText(IDC_URL,DEFAULT_URL);

    s.Format("%d",DEFAULT_TIMEOUT_SECS);
	SetDlgItemText(IDC_TIMEOUT,s);

	s.Format("%d",DefaultFingerPort());
	SetDlgItemText(IDC_PORT,s);

	SyncUndo();
}

void CAliveDialog::OnUndo ()
{
	CString s;

	// Restore the dialog strings from before the last apply

	s.Format("%d",u_port);

	SetDlgItemText(IDC_PORT,s);
	SetDlgItemText(IDC_URL,u_URL);

	s.Format("%d",u_timeout);
	SetDlgItemText(IDC_TIMEOUT,s);

	OnApply();

	// nothing to undo, it's been undone
	((CButton *)GetDlgItem(IDC_UNDO))->EnableWindow(FALSE);
}

void CAliveDialog::OnApply ()
{
	CWinApp* pApp = AfxGetApp();
	CString s_port,s_timeout;
	char buf[512],*c=buf;

	// Copy the current applied state into the UNDO buffer

	u_URL = m_URL;
	u_timeout = m_timeout;
	u_port = m_port;

	// Apply the dialog strings & reset the timer & apply state

	GetDlgItemText(IDC_URL,m_URL);
	GetDlgItemText(IDC_PORT,s_port);
    m_port=atoi(s_port);

	GetDlgItemText(IDC_TIMEOUT,s_timeout);
    m_timeout=atoi(s_timeout);

	// Apply to the Registry settings, too

	pApp->WriteProfileString(KEY_VERSION,KEY_DEFAULT_URL,m_URL);
	pApp->WriteProfileInt(KEY_VERSION,KEY_DEFAULT_TIMEOUT,m_timeout);
    pApp->WriteProfileInt(KEY_VERSION,KEY_DEFAULT_PORT,m_port);

	MySetTimer();

	// We've applied, so disable the Apply button until the next change
	((CButton *)GetDlgItem(IDC_APPLY))->EnableWindow(FALSE);
}

BOOL CAliveDialog::PrintFinger (BOOL init,BOOL err,BOOL done)
{
	char *c=ts.fingerInBuf;

	// PrintFinger must be called once upon completion,
	// successful or not. This is how we know we're done.

	if (init)
		c="Attempting to contact host...";

	if (err) {
		c="Couldn't contact host.";
		ts.hostIP.s_addr=0;
	}

	if (err || done) {
		SetDlgItemText(IDC_RESPONSE,c);
		ts.inProgress=FALSE;
	}

	SetDlgItemText(IDC_HOSTIP,inet_ntoa(ts.hostIP));

	return(err);	// for function chaining
}

void CAliveDialog::OnEditChange ()
{
	// We've changed something, let the user know s/he should apply or undo
	((CButton *)GetDlgItem(IDC_APPLY))->EnableWindow(TRUE);
	((CButton *)GetDlgItem(IDC_UNDO))->EnableWindow(TRUE);
}
