#include <afxwin.h>
#include <winsock.h>
#include "Resource.h"
#include "KeepAlive.h"

// aboutclass.cpp - CAboutDialog (about box) code

/////////////////////////////////////////////////////////////////////////
// CAboutDialog message map and member functions

BEGIN_MESSAGE_MAP (CAboutDialog, CDialog)
    ON_WM_PAINT ()
END_MESSAGE_MAP ()

BOOL CAboutDialog::OnInitDialog ()
{
    CDialog::OnInitDialog ();

	// Remove dialog's placeholder box and cache its space as
	// a rectangle that we can render into later

    CStatic* pStatic = (CStatic*) GetDlgItem (IDC_ICONRECT);
    pStatic->GetWindowRect (&m_rect);
    pStatic->DestroyWindow ();
    ScreenToClient (&m_rect);

    return TRUE;
}

void CAboutDialog::OnPaint ()
{
    CPaintDC dc (this);
    HICON hIcon = AfxGetMainWnd ()->GetIcon (TRUE);

    if (hIcon != NULL) {	// Render icon in dialog, cool
        CDC dcMem;
        dcMem.CreateCompatibleDC (&dc);

        CBitmap bitmap;
        bitmap.CreateCompatibleBitmap (&dc, 32, 32);
        CBitmap* pOldBitmap = dcMem.SelectObject (&bitmap);

        CBrush brush (::GetSysColor (COLOR_3DFACE));
        dcMem.FillRect (CRect (0, 0, 32, 32), &brush);
        dcMem.DrawIcon (0, 0, hIcon);

        dc.StretchBlt (m_rect.left, m_rect.top, m_rect.Width(),
            m_rect.Height (), &dcMem, 0, 0, 32, 32, SRCCOPY);

        dcMem.SelectObject (pOldBitmap);
    }
}