//***********************************************************************
//
//  KeepAlive.h
//
//***********************************************************************

class CMyApp : public CWinApp
{
private:
	BOOL socketsInit;					// TRUE if WSAStartup() successful
	WSADATA wsad;						// WSAStartup() return info
public:
    virtual BOOL InitInstance ();
	virtual int ExitInstance();
};

#define LOOKUP_EVENT (WM_USER+1)			// Async DNS search done
#define WINSOCK_EVENT (WM_USER+2)		// Multi-purpose winsock events

class CAliveDialog : public CDialog
{
private:
    CString	m_URL;	// user dialog field result
	int	m_timeout;	// user dialog field result
	int	m_port;		// user dialog field result

    CString	u_URL;	// UNDO equivalents
	int	u_timeout;
	int	u_port;	

	BOOL firstTime;	// Set TRUE to kick off quick finger upon startup

	// Scratch state variables that need to be preserved
	// across async calls - yuk. How much of this could we
	// really do away with?

	struct temp_state {
		struct in_addr hostIP;	// Host's queried IP address

		SOCKET s;				// we'll be using this in async mode
		char acHostInfo[MAXGETHOSTSTRUCT];	// hostent storage for DNS lookup

		SOCKADDR_IN sin;					// port details to connect on
		char userName[256];		// Cooked: "user@test.com" -> "user\0test.com"
		char fingerOutBuf[256];
		char fingerInBuf[512];
		int nBytesXferred;
		int nBytesToXfer;
		int nBytesReceived;
		BOOL inProgress;	// waiting for finger result if TRUE
	} ts;

public:
    CAliveDialog ();
    virtual BOOL OnInitDialog ();

protected:
	virtual void OnOK();
    virtual void OnCancel ();
    virtual void PostNcDestroy ();

    afx_msg void OnPaint ();
    afx_msg void OnSysCommand (UINT, LPARAM);	// for intercepting sys menu about box events
	afx_msg void OnDefault ();
	afx_msg void OnUndo ();
	afx_msg void OnApply ();
	afx_msg BOOL PrintFinger (BOOL,BOOL,BOOL);
	afx_msg void OnEditChange ();
	afx_msg void OnTimer (UINT);
	afx_msg LRESULT OnLookupEvent (WPARAM,LPARAM);	// New for async sockets
	afx_msg LRESULT OnWinsockEvent (WPARAM,LPARAM);	// New for async sockets
	
	void	MySetTimer ();
	void	SyncUndo ();
	void	RestoreSettings ();

	BOOL ConnectHostAsync(const char *host);
	BOOL OnFinger();

    DECLARE_MESSAGE_MAP ()
};

class CAboutDialog : public CDialog
{
private:
    CRect m_rect;

public:
    CAboutDialog (CWnd* pParentWnd = NULL) :
        CDialog (IDD_ABOUTDLG, pParentWnd) {}

    virtual BOOL OnInitDialog ();

protected:
    afx_msg void OnPaint ();
    DECLARE_MESSAGE_MAP ()
};

// public network & protocol routines in netcom.cpp

LONG GetHostID();
short DefaultFingerPort();
void FilterBuf(char *buf,int bufSiz);

#define STARTUP_FINGER_SECS 1		// Note: no startup finger if below is "0"

#define KEY_DEFAULT_TIMEOUT "DefaultTimeout"
#define KEY_DEFAULT_PORT "Default Port"
#define KEY_DEFAULT_URL "DefaultURL"
#define KEY_VERSION "3.0"

#define DEFAULT_TIMEOUT_SECS 35
#define DEFAULT_URL "root@ucsd.edu"

#define ID_TIMER_CLOCK 1
