/*
   EEN 591 Final Project - Dallas Hodgson - 12/8/98
   
   KeepAlive thwarts cheapo ISP's from disconnecting you during periods
   of idle by performing a harmless "finger" of a non-existent person
   once a minute or so (user-definable). Run it minimized in the background
   and be happy!

   KeepAlive performs its first finger immediately upon running; if you put
   it in your StartUp group, this can have the advantage of dialing up your
   ISP immediately upon boot (if you've configured your Internet Settings).

   Note that this version displays the IP addresses of both the client
   and the hosts contacted, making it a useful debugging tool as well.

   Note that I used "finger", rather than "ping" here because:

   1) I already had source
   2) It was guaranteed to work
   3) I didn't have any ping code handy.

   KeepAlive 3.0 uses a modeless dialog box as its main window. Use of asynchronous
   Winsock calls prevents Windows from locking up when fingering down servers. I'd
   eventually like to make use of the new MFC Internet classes here. Additionally,
   would it make any sense to move the UNDO buffer into CMyApp somehow w/DDX? User
   settings are saved in the Registry.

   TBD: KeepAlive doesn't bother to abort any Winsock calls in progress
   if the user exits the program in the middle of a request. Doesn't seem
   to hurt anything, though.

   Link with wsock32.lib.

   Thanks to the following for code and inspiration: 
     Mark Gamber (Winfin), Jeff Prosise (DlgCalc),
     Bob Quinn & Dave Shute (Windows Sockets Network Programming)
 
   REVISION HISTORY

   2.1 - Registry support added, ala Prosise's "Clock". Rebuilt with VC++ 5.0.
   2.2 - Missing WSACleanup() code added
   2.3 - Added code to display client & server IP addresses.
		 Sockets code more thorough in checking return codes, faster.
		 Modularized for future expansion.
   2.4 - DefaultFingerPort() now queries winsock for completeness
   3.0 - Uses asynchronous Winsock calls for the first time.
 */

#include <afxwin.h>
#include <winsock.h>
#include "Resource.h"
#include "KeepAlive.h"

CMyApp myApp;

/////////////////////////////////////////////////////////////////////////
// CMyApp member functions

BOOL CMyApp::InitInstance ()
{
	socketsInit = FALSE;				// assume failure
		
	if(WSAStartup(0x0101,&wsad))		// Initialize 1.1 sockets here
   		return FALSE;					// or fail app if sockets fails
	
	socketsInit = TRUE;

	SetRegistryKey("RockIsland");		// Use Registry instead of .INI files
										// HKEY_CURRENT_USER/Software/RockIsland/KeepAlive/2.3
										// AFX_IDS_APP_TITLE resource defines program name

    m_pMainWnd = new CAliveDialog;
    m_pMainWnd->ShowWindow (m_nCmdShow);
    m_pMainWnd->UpdateWindow ();

    return TRUE;
}

int CMyApp::ExitInstance ()
{
	if (socketsInit)
		return(WSACleanup());
	
	return(0);
}